<?php

/**
 * Basic check for folder/file permissions 
 *
 * @copyright (c) 2007, Andreas Krapohl
 * @link http://www.cms-sicherheit.de
 * @license GNU/GPL - http://www.gnu.org/copyleft/gpl.html
 * @license http://www.gnu.org/copyleft/gpl.html
*/

error_reporting(E_ALL);

function filelist ($startdir="./", $maxlevel="all", $level=1) {
/**
 * get filelist
 *
 * @author mstabile75 at gmail dot com
 * @author Andreas Krapohl - http://www.cms-sicherheit.de
 * @return array
 * @argument $startdir => specify the directory to start from; format: must end in a "/"
 * @argument $maxlevel => "all" or a number; specifes the number of directories down that you want to search
 * @argument $level => integer; directory level that the function is currently searching
 * @argument $ignoredDirectory[] => array; the directory/file names that you want to ignore
*/
    $directorylist=array();
    $ignoredDirectory[] = ".";
    $ignoredDirectory[] = "..";
 
    @set_time_limit(0);
    if (is_dir($startdir)) {
        if ($dh = @opendir($startdir)) {
            while (($file = readdir($dh)) !== false) {
                if (!(array_search($file,$ignoredDirectory) > -1)) {
                 if (filetype($startdir . $file) == "dir") {
                       $directorylist[$startdir . $file]['level'] = $level;
                       $directorylist[$startdir . $file]['dir'] = 1;
                       $directorylist[$startdir . $file]['name'] = $file;
                       $directorylist[$startdir . $file]['path'] = $startdir;
                       $directorylist[$startdir . $file]['writable'] = (bool)is_writable($startdir . $file);
                       if ((($maxlevel) == "all") or ($maxlevel > $level)) {
                           $list2 = filelist($startdir . $file . "/", $maxlevel, $level + 1);
                           if(is_array($list2)) {
                               $directorylist = array_merge($directorylist, $list2);
                           }
                        }

                   } else {
                         $directorylist[$startdir . $file]['level'] = $level;
                         $directorylist[$startdir . $file]['dir'] = 0;
                         $directorylist[$startdir . $file]['name'] = $file;
                         $directorylist[$startdir . $file]['path'] = $startdir;
                         $directorylist[$startdir . $file]['writable'] = (bool)@fopen($startdir . $file, 'a');
                   }
                 }
            }
           closedir($dh);
        }
    }
return($directorylist);
}
?>
	
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" 
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="de" xml:lang="de-de">
	<head>
		<title>Filesystemcheck</title>
	</head>
	<body>
  <h1>Securitycheck - bitte Datei wieder vom Webspace entfernen!</h1>
  <h3>...einen Moment Geduld...</h3>

  <?
  $files = filelist(); // call the function
  ?>

  <h3>Die folgenden Verzeichnisse und Dateien sind beschreibbar:</h3>
  <ul>

  <?
  foreach ($files as $list) {//print array
	  if ($list['writable']==1) {
      echo "<li>" . $list['path'] . "" . $list['name'] . "</li>\n";
    }
  }
  ?>

  </ul>
  <p>TIPP: Generelle PHP-Konfiguration mit <a href="http://www.cms-sicherheit.de/module-blog-viewpub-tid-1-pid-8.html">PHPSecInfo</a> prfen!</p>
  <p><small>&copy; 2007 Andreas Krapohl | <a href="http://www.cms-sicherheit.de">cms-sicherheit.de</a></small></p>
  </body>
</html>